package cn.com.duiba.tuia.adx.center.api.enums;

public enum IQIYIAdvertiserAuditStatusEnum {


    WAIT(1,"WAIT","待审核"),
    PASS(2,"PASS","审核通过"),
    REFUSE(3,"UNPASS","审核不通过");

    private Integer code;

    private String status;

    private String description;

    IQIYIAdvertiserAuditStatusEnum(Integer code, String status, String description) {
        this.code = code;
        this.status = status;
        this.description = description;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public static Integer getCode(String status){
        for(IQIYIAdvertiserAuditStatusEnum iqiyiAdvertiserAuditStatusEnum : IQIYIAdvertiserAuditStatusEnum.values()){
            if(iqiyiAdvertiserAuditStatusEnum.getStatus().equals(status)){
                return iqiyiAdvertiserAuditStatusEnum.getCode();
            }
        }
        return IQIYIAdvertiserAuditStatusEnum.WAIT.getCode();
    }
}
