/**
 * Copyright (c) 2021, duiba.com.cn All Rights Reserved.
 */
package cn.com.duiba.tuia.adx.center.api.dto;

import lombok.Data;

import java.io.Serializable;

/**
 * 描述: 创意素材-素材详情简单版(防止IO问题)
 *
 * @author guopengfei@duiba.com.cn
 * @version v1.0
 * @date 2021/3/31 15:16
 */
@Data
public class MaterialDetailDto implements Serializable {
    private static final long serialVersionUID = 4224864479318221386L;

    private Long materialId;

    /* 素材类型 1-图片 3-视频 */
    private Integer type;

    private String url;

    private Integer width;

    private Integer height;

    private Long size;

    private Double duration;

    private String coverUrl;

    private Integer coverWidth;

    private Integer coverHeight;

    private Integer isIcon;
}
