package cn.com.duiba.tuia.adx.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.adx.center.api.dto.DataDspCostDto;
import cn.com.duiba.tuia.adx.center.api.dto.DspFlowConfigDto;
import cn.com.duiba.tuia.adx.center.api.dto.DspInfoDto;

import java.util.List;


/**
 * dsp相关远程服务
 */
@AdvancedFeignClient
public interface RemoteDspService {
    //获取所有dsp
    List<DspInfoDto> getAllDsp();

    //获取所有DspId
    List<Long> getAllDspId();

    //根据dspId获取dsp信息
    DspInfoDto getDspInfo(Long dspId);

    //根据dspId获取dsp配置
    List<DspFlowConfigDto> getDspFlowConfig(Long dspId);

    //数据上报
    void report(DataDspCostDto dataDspCostDto);

}
