package cn.com.duiba.tuia.adx.proxy.service.api.dto.creative;

import lombok.Data;

import java.io.Serializable;
import java.util.List;

@Data
public class CreativeDTO implements Serializable {
    private static final long serialVersionUID = 7727303021960366209L;

    /**
     * 推广组id
     */
    private Long groupId;

    /**
     * 资源位id
     */
    private Long resourceId;

    /**
     * 创意计划id
     */
    private Long ideaId;

    /**
     * adx平台定义的广告主id
     */
    private String adxAdvertiserId;

    /**
     * 推啊定义的创意id
     */
    private String dspCreativeId;

    /**
     * 推啊定义的审核id
      */
    private String dspCreativeAuditId;

    /**
     * adx平台定义的创意审核类型
     */
    private String adxCreativeAuditType;

    /**
     * adx平台定义的创意类型，比如：开屏类型
     */
    private String adxCreativeType;

    /**
     * adx平台定义的创意样式id，比如：15 对应 一图一文
     */
    private String adxCreativeStyle;

    /**
     * 创意标题
     */
    private String creativeTitle;

    /**
     * 创意描述
     */
    private String creativeDesc;

    /**
     * 落地页地址
     */
    private String landingPageUrl;

    /**
     * 创意中的视频list
     */
    private List<VideoDTO> videoDTOList;

    /**
     * 创意中的图片list
     */
    private List<ImageDTO> imageDTOList;
}
