package cn.com.duiba.tuia.adx.proxy.service.api.dto.creative;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

@Data
public class VideoDTO implements Serializable {
    private static final long serialVersionUID = 7165597335226198108L;

    /**
     * 视频广告 Url
     */
    private String              videoUrl;

    /**
     * 视频大小 ( 单位 :: Byte )
     */
    private Integer             videoSize;

    /**
     * 视频单位 ( 单位 :: Byte )
     */
    private String              unit;

    /**
     * 视频时长 ( 单位 :: Secend/秒 )
     */
    private BigDecimal duration;

    /**
     * 视频分辨率水平显示每英寸点（ dpi ）的数量
     * 如: ( x ) 1280 x ( y ) 720 宽
     */
    private Integer             resolutionX;

    /**
     * 视频分辨率垂直显示每英寸点（ dpi ）的数量
     * 如: ( x ) 1280 x ( y ) 720 高
     */
    private Integer             resolutionY;

    /**
     * 视频封面图片 Url
     */
    private String              coverUrl;

    /**
     * 视频封面图片宽度
     */
    private Integer             coverWidth;

    /**
     * 视频封面图片高度
     */
    private Integer             coverHeight;
}
