package cn.com.duiba.tuia.algo.engine.api.remoteservice.adx;

import cn.com.duiba.nezha.alg.alg.vo.adx.flowfilter.AdxFlowFilterDo;
import cn.com.duiba.tuia.activity.center.api.dto.adx.ResourceIdeaDto;
import cn.com.duiba.tuia.algo.engine.api.adx.AlgoChoiceIdeaResult;
import cn.com.duiba.tuia.algo.engine.api.adx.BidFlowFeature;

import java.util.List;

/**
 * adx 创意选择服务
 *
 * @author peanut.huang
 * @date 2020/3/19
 * @since JDK 1.8
 */
public interface RemoteAdxIdeaSelectService {

    /**
     * 通过算法1.0 选择一个创意
     *
     * @param resourceLocationId
     * @param ideaList
     * @param bidFlowFeature
     * @return
     */
    AlgoChoiceIdeaResult choiceIdea(Long resourceLocationId, List<ResourceIdeaDto> ideaList, BidFlowFeature bidFlowFeature);

    /**
     * 通过算法2.0选择一个创意
     *
     * @param resourceLocationId
     * @param ideaList
     * @param bidFlowFeature
     * @return
     */
    AlgoChoiceIdeaResult choiceIdeaPlus(Long resourceLocationId, List<ResourceIdeaDto> ideaList, BidFlowFeature bidFlowFeature);


    /**
     * 互动创意流量过滤
     *
     * @param ideaDtoList
     * @param bidFlowFeature
     */
    void interactIdeaFlowFilter(List<ResourceIdeaDto> ideaDtoList, BidFlowFeature bidFlowFeature);
}
