/**
 * Copyright (c) 2020, duiba.com.cn All Rights Reserved.
 */
package cn.com.duiba.tuia.algo.engine.api.adx;

import cn.com.duiba.nezha.alg.alg.vo.adx.pd.AdxIdeaRcmdResultDo;
import lombok.Data;

import java.io.Serializable;

/**
 * 描述: pd流量特征
 *
 * @author guopengfei@duiba.com.cn
 * @version v1.0
 * @date 2020/5/13 17:43
 */
@Data
public class PdBidFlowFeature implements Serializable {
    private static final long serialVersionUID = -8930193361469906480L;

    /**
     * 推啊排期单ID
     */
    private Long tuiaDealId;

    /**
     * pmp-deal出价
     */
    private Long pmpPrice;

    /**
     * pd创意筛选结果集
     */
    private AdxIdeaRcmdResultDo adxIdeaRcmdResultDo;

    /**
     * 点击价值分层
     */
    private Integer clickValueLevel;

    /**
     * 点击价值纠偏因子
     */
    private Double clickValueRectifyFactor;

    /**
     * 预估点击价值(TFModel)
     */
    private Double preClickValue;

    /**
     * 统计点击价值
     */
    private Double statClickValue;
}
