package cn.com.duiba.tuia.algo.engine.api.remoteservice.adx;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.nezha.alg.alg.vo.adx.pd.AdxIdeaRcmdResultDo;
import cn.com.duiba.tuia.activity.center.api.dto.adx.ResourceIdeaDto;
import cn.com.duiba.tuia.algo.engine.api.adx.BidFlowFeature;

import java.util.List;

@AdvancedFeignClient
public interface RemoteAdxIdeaChoiceService {

    /**
     * 通过算法新架构选择一个创意（PD）
     * <p>
     * 目前只支持PD互动<>2020-05-09</>
     *
     * @param resourceLocationId
     * @param ideaList
     * @param bidFlowFeature
     * @param manualIdeaId 人工投放时，人工筛选的创意ID，算法投放时为空。
     * @return
     */
    AdxIdeaRcmdResultDo choicePDIdea(Long resourceLocationId, List<ResourceIdeaDto> ideaList, BidFlowFeature bidFlowFeature, Long manualIdeaId);

    /**
     * 人工出创意（RTB）
     *
     * @param resourceLocationId
     * @param ideaList
     * @param bidFlowFeature
     * @param manualIdeaId 人工投放时，人工筛选的创意ID，算法投放时为空。
     * @return
     */
    AdxIdeaRcmdResultDo manualChoiceRTBIdea(Long resourceLocationId, List<ResourceIdeaDto> ideaList, BidFlowFeature bidFlowFeature, Long manualIdeaId);

    /**
     * 算法出创意（RTB）
     * @param resourceLocationId
     * @param ideaList
     * @param bidFlowFeature
     * @return
     */
    AdxIdeaRcmdResultDo algoChoiceRTBIdea(Long resourceLocationId, List<ResourceIdeaDto> ideaList, BidFlowFeature bidFlowFeature);


}
