package cn.com.duiba.tuia.algo.engine.api.remoteservice.adx;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.nezha.alg.alg.vo.adx.pd.AdxIdeaRcmdResultDo;
import cn.com.duiba.tuia.activity.center.api.dto.adx.ResourceIdeaDto;
import cn.com.duiba.tuia.algo.engine.api.adx.AdxFlowFilterResult;
import cn.com.duiba.tuia.algo.engine.api.adx.AlgoChoiceIdeaResult;
import cn.com.duiba.tuia.algo.engine.api.adx.BidFlowFeature;

import java.util.List;

/**
 * adx 创意选择服务
 *
 * @author peanut.huang
 * @date 2020/3/19
 * @since JDK 1.8
 */
@AdvancedFeignClient
public interface RemoteAdxIdeaSelectService {

    /**
     * 通过算法1.0 选择一个创意
     *
     * @param resourceLocationId
     * @param ideaList
     * @param bidFlowFeature
     * @return
     */
    AlgoChoiceIdeaResult choiceIdea(Long resourceLocationId, List<ResourceIdeaDto> ideaList, BidFlowFeature bidFlowFeature);

    /**
     * 通过算法2.0选择一个创意
     *
     * @param resourceLocationId
     * @param ideaList
     * @param bidFlowFeature
     * @return
     */
    AlgoChoiceIdeaResult choiceIdeaPlus(Long resourceLocationId, List<ResourceIdeaDto> ideaList, BidFlowFeature bidFlowFeature);


    /**
     * 互动创意流量过滤：人工选择创意时需要对流量进行过滤
     *
     * @param resourceLocationId
     * @param ideaDto
     * @param bidFlowFeature
     */
    AdxFlowFilterResult interactIdeaFlowFilter(Long resourceLocationId, ResourceIdeaDto ideaDto, BidFlowFeature bidFlowFeature);



}
