package cn.com.duiba.tuia.algo.engine.api.remoteservice.adx;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.nezha.alg.alg.vo.adx.rtb.AdxRtbBidResultDo;
import cn.com.duiba.tuia.activity.center.api.constant.adx.IdeaPKTypeEnum;
import cn.com.duiba.tuia.activity.center.api.dto.adx.ResourceIdeaDto;
import cn.com.duiba.tuia.algo.engine.api.adx.AdxMixBidResult;
import cn.com.duiba.tuia.algo.engine.api.adx.AlgoChoiceIdeaResult;
import cn.com.duiba.tuia.algo.engine.api.adx.BidFlowFeature;
import cn.com.duiba.tuia.algo.engine.api.adx.IdeaBidPriceResult;

import java.util.List;

/**
 * 〈一句话功能简述〉<br>
 * Description: adx算法出价远程服务类
 *
 * @author hillchen
 * @create 2019/2/27 17:27
 */
@AdvancedFeignClient
public interface RemoteAdxAlgoBidService {
    /**
     * 算法出价
     *
     * @param ideaDto
     * @param bidFlowFeature
     * @return
     */
    IdeaBidPriceResult bidPrice(ResourceIdeaDto ideaDto, BidFlowFeature bidFlowFeature);

    /**
     * 算法出价(升级)
     *
     * @param bidFlowFeature
     * @param ideaDto
     * @return
     */
    IdeaBidPriceResult bidPrice(BidFlowFeature bidFlowFeature, ResourceIdeaDto ideaDto);


    /**
     * 直投算法出价
     *
     * @param ideaDto
     * @param bidFlowFeature
     * @return
     */
    IdeaBidPriceResult directlyBidPrice(ResourceIdeaDto ideaDto, BidFlowFeature bidFlowFeature);

    /**
     * 创意pk
     *
     * @param ideaPkType             pk评判标准
     * @param bidPriceResultList    多个竞价结果集
     * @return  胜出的竞价结果
     */
    AdxMixBidResult ideaPk(IdeaPKTypeEnum ideaPkType, List<IdeaBidPriceResult> bidPriceResultList);

    /**
     * 人工出价记录特征日志
     *
     * @param ideaDto
     * @param bidFlowFeature
     */
    void recordManualFeatureLog(ResourceIdeaDto ideaDto, BidFlowFeature bidFlowFeature);

    /**
     * 通过算法选择一个创意
     *
     * @param ideaDtoList
     * @return
     *
     * filterIdeaByAlgo 废弃，以后用filterIdeaByAlgoFix
     */

    Long filterIdeaByAlgo(List<ResourceIdeaDto> ideaDtoList);


    Long filterIdeaByAlgoFix(Long resourceLocationId, List<Long> ideaIdList);

    /**
     * 通过算法选择一个创意2.0
     * @param ideaDtoList
     * @param bidFlowFeature
     * @param groupId
     * @param adxType
     * @return
     */
    AlgoChoiceIdeaResult choiceIdeaByAlgoPlusFix(List<ResourceIdeaDto> ideaDtoList, BidFlowFeature bidFlowFeature, Long groupId, Integer adxType);

    /**
     * 手动清理算法库存
     * @return
     */
    void rpcClearLocalTFModel();


}