package cn.com.duiba.tuia.algo.engine.api.adx;

import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;

/**
 * adx 流量预过滤结果
 *
 * @author peanut.huang
 * @date 2020/3/23
 * @since JDK 1.8
 */
@Data
@Accessors(chain = true)
public class AdxFlowFilterResult implements Serializable {

    private static final long serialVersionUID = 2350642616640270733L;

    /**
     * 流量过滤标记（0：不过滤；1：过滤）
     */
    private Integer flowFilterLabel;

    /**
     * ctr预估区间
     */
    private Integer preInterval;

    /**
     * abtest分流标记（1：对比组；2：测试组）
     */
    private Integer filterIndex;

    /**
     * 每pv发券预估值
     */
    private Double preLaunchPv;

    /**
     * 0-不过滤，1-流量预过滤，2-每pv发券过滤
     */
    private Integer filterType;
}
