package cn.com.duiba.tuia.algo.engine.api.adx;

import cn.com.duiba.bigdata.online.service.api.dto.AdxInCommonDto;
import cn.com.duiba.nezha.alg.alg.vo.adx.pd.AdxStatsDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.rcmd.AdxMaterialRecallDo;
import cn.com.duiba.nezha.alg.feature.vo.DmpFeature;
import cn.com.duiba.tuia.ssp.center.api.dto.MaterialDto;
import lombok.Data;

import java.io.Serializable;
import java.util.List;
import java.util.Map;

/**
 * 〈一句话功能简述〉<br>
 * Description: 算法出价流量特征对象
 *
 * @author hillchen
 * @create 2019/2/26 14:10
 */
@Data
public class BidFlowFeature implements Serializable {

    private static final long serialVersionUID = -7315137301626424927L;

    private String adxRid;
    private String tagId;
    private String imei;
    private String realImei;
    private String oaid;
    private String idfa;
    private String ip;
    private String ua;
    private String os;


    private String cat;
    private String tuiaCat;
    private String sectionCat;
    private String tuiaSectionCat;
    private String keywords;

    private Integer posType;
    private Integer posStyle;
    private Integer resourcePicH;
    private Integer resourcePicW;

    private Long areaCode;
    private Integer deviceType;
    private Integer tuiaDeviceType;
    private String make;
    private String model;
    private String carrier;
    private Integer connectionType;
    private Integer tuiaConnectionType;
    private Float lat;
    private Float lon;
    private Long currentCreatTime;

    private String gender;

    /** 底价(分/千次曝光) 来源：adx请求 */
    private Double basePrice;

    /** 策略标记 */
    private String strategy;

    //新增adx流量特征
    //用户
    /** 用户兴趣 f5010020 */
    private String interestKeyWords;

    /** 出生年月 f5010030 */
    private String yob;

    //上下文-新增
    /** 应用名称 f6010010 */
    private String appName;

    /** 包名 f6010020 */
    private String appBundle;

    /** 应用当前页类型 f6010030 */
    private String appPageCat;

    /** 0-免费 1-付费 f6010040 */
    private Integer appPaid;

    /** 设备位置信息-国家 f6010050 */
    private String geoCountry;

    /** 设备位置信息-地区 f6010060 */
    private String geoRegion;

    /** 设备位置信息-城市 f6010070 */
    private String geoCity;

    /** 设备位置信息-定位类型 f6010080 */
    private Integer geoType;

    /** 预发券对象 */
    private List<AdxLoadAdvert> adxLoadAdvertList;

    /** 计费类型：1、一价计费；2、二价计费 */
    private Integer feeType;

    /** 请求ID，由ADX生成并传递，用于定位问题 */
    private String requestId;

    /** 曝光次数关系 */
    private String expTimeMap;

    /** 规格位编码，多个用逗号分隔 */
    private String specCode;

    /** 样式规格 */
    private Integer styleStandard;

    /** 竞价广告位顺序索引 */
    private Integer tagIndex;

    /** 设备号 当天竞价次数 */
    private Map<String, Long> imeiDayBidTimes;
    /** 设备号 当天曝光次数 */
    private Map<String, Long>  imeiDayExpTimes;
    /** 资源位id+设备号 当天竞价次数 */
    private Map<String, Long>  resoDayBidTimes;
    /** 资源位id+设备号 当天曝光次数 */
    private Map<String, Long>  resoDayExpTimes;

    /**模型融合收益*/
    private Double mergeRpm;
    /**模型预估收益*/
    private Double pRpm;
    /**模型预估收益*/
    private Double sRpm;

    /**用户标签列表**/
    private String userTagsList;
    /**app安装列表**/
    private String appList;
    /**短信签名列表**/
    private String messageNameList;

    /**
     * 经纬度
     */
    private Double longitude;

    /**
     * 经纬度
     */
    private Double latitude;

    /**
     * 经纬度hash
     */
    private String geohash;

    private String algType;

    /** 0.测试组 1.对照组 **/
    private Integer isTestGroup;

    /**
     * dmp流量特征
     */
    private DmpFeature dmpFeature;

    /**
     * 流量预过滤对象
     */
    private AdxFlowFilterResult flowFilterResult;

    /**
     * 大媒体视频对象信息
     */
    private VipVideoInfo videoInfo;

    /**
     * @see cn.com.duiba.tuia.activity.center.api.constant.adx.PmpType
     */
    private Integer pmpType;

    /**
     * PD流量特征
     */
    private PdBidFlowFeature pdBidFlowFeature;

    /**
     * 百度联盟appId
     */
    private String baiduAppId;

    /**
     * 流量标识 :: 是否 Web 流量.
     */
    private boolean isWebTraffic;

    /**
     * 三方用户 Id
     * 注: 目前百度联盟 Web 流量使用.
     */
    private String thirdUserId;

    /**
     * 投放方式：0.依次  1.按比例  2.算法1.0  3.算法2.0
     */
    private Integer putType;

    /**
     * 创意点击价值-预估TF模型
     */
    private Double preClickValue;

    /**
     * 创意点击率-fm模型预估值
     */
    private Double preCtr;

    /**
     * 创意点击价值分层
     */
    private Integer clickValueLevel;

    /**
     * 点击价值纠偏因子
     */
    private Double clickValueRectifyFactor;

    /**
     * ctr预估区间
     */
    private Integer preInterval;

    /** 流量abtest组别  1=adx非测试流量，2=无，3=每pv发券，4=每pv点券 **/
    private Integer flowGroup;

    /**
     * 请求流量尺寸
     */
    private MaterialSpecInfo materialSpecInfo;

    /**
     * 入口素材id
     */
    private Long materialId;

    /**
     * 要求素材比例 使用防止为空
     */
    private Integer ratioType;

    /**
     * 要求素材类型 使用防止为空
     */
    private Integer materialType;

    /**
     * DPA全部可投素材列表(不得已而为之，可能为空，慎用)
     */
    private List<MaterialDto> materialDtoList;

    /**
     * DPA召回投素材列表(不得已而为之，可能为空，慎用)
     */
    private AdxMaterialRecallDo adxMaterialRecallDo;

    /**
     * DPA素材统计数据(不得已而为之，可能为空，慎用)
     */
    private Map<Long, AdxStatsDo> dpaMaterialStatisticsDataMap;

    /**
     * DPA素材统计数据(不得已而为之，可能为空，慎用)
     */
    private Map<Long, AdxStatsDo> dpaResoMaterialStatisticsDataMap;

    /**
     * DPA素材DMP数据(不得已而为之，可能为空，慎用)
     */
    private AdxInCommonDto adxInCommonDto;


}