package cn.com.duiba.tuia.algo.engine.api.req;

import cn.com.duiba.tuia.algo.engine.api.adx.MeituanAdvertDto;
import cn.com.tuia.advert.model.SimpleAppAdvertDto.SimpleMeituanAdvertDto;
import lombok.Data;

import java.io.Serializable;
import java.util.List;
import java.util.Map;

@Data
public class MeiTuanBidPriceReq implements Serializable {

    private static final long serialVersionUID = 2080517338720772972L;

    /**
     * 广告位ID
     */
    private Long slotId;

    /**
     * 媒体id
     */
    private Long mediaId;

    /**
     * 广告位维度设置的目标分成比例
     */
    private Double slotShareRate;

    /**
     * 出券(个数)
     */
    private Integer advertCount;

    /**
     * 底价（单位：分）
     */
    private Double floorPrice;

    /**
     * 美团外卖媒体用的广告配置集合
     */
    private List<MeituanAdvertDto> meituanAdvertList;

    private Integer groupTag;

    /**
     * 头部流量竞价次序调价用户阈值
     */
    private Long headBidPriceReqThreshold;

    /**
     * 头部流量竞价次序调价策略ab测试分组标识
     */
    private Integer headBidPriceAbTestGroupTag;

    private String deviceId;

    /**
     * ab分流组map
     */
    private Map<String, Integer> groupTagMap = null;

}
