package cn.com.duiba.tuia.algo.engine.api.adx;

import cn.com.duiba.tuia.activity.center.api.annotation.AdxBidFullLink;
import lombok.Data;
import lombok.ToString;

import java.io.Serializable;

/**
 * 〈一句话功能简述〉<br>
 * Description: 出价返回结果
 *
 * @author hillchen
 * @create 2019/2/26 14:06
 */
@Data
@ToString
public class IdeaBidPriceResult implements Serializable {

    private static final long serialVersionUID = -8075147928617693291L;

    /**
     * adxRid
     */
    private String adxRid;

    /**
     * 创意id
     */
    private Long ideaId;

    /**
     * 资源位id
     */
    private Long resourceId;

    /**
     * 出价类型 {@link cn.com.duiba.tuia.activity.center.api.constant.adx.PriceType#type}
     */
    private int priceType;

    /** 标准出价:分/1000次 */
    private Long price;

    /** adxPriceLevel */
    private Integer adxPriceLevel;

    /** isCompareGroup */
    private String isCompareGroup;

    /** 试探level */
    private String level;

    /** 算法出价接口使用后的返回strategy（用于排除问题，后面下掉） */
    private String strategy;

    /*
     * 策略类型
     * 注: 算法策略类型.
     */
    private String algType;

    /**
     * 点击价值纠偏因子
     */
    private Double clickValueRectifyFactor;

    /**
     * 点击价值分层
     */
    private Integer clickValueLevel;

    /** 流量abtest组别  1=adx非测试流量，2=无，3=每pv发券，4=每pv点券 **/
    private Integer flowGroup;

}