package cn.com.duiba.tuia.algo.engine.api.remoteservice.adx;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.nezha.alg.alg.vo.adx.rcmd.AdxResourceRcmdDo;
import cn.com.duiba.tuia.activity.center.api.dto.adx.ResourceIdeaDto;
import cn.com.duiba.tuia.algo.engine.api.adx.AdxChoiceIdeaResult;
import cn.com.duiba.tuia.algo.engine.api.adx.AdxFlowFilterResult;
import cn.com.duiba.tuia.algo.engine.api.adx.BidFlowFeature;

import java.util.List;

@AdvancedFeignClient
public interface RemoteAdxRTBIdeaChoiceService {

    /**
     * 人工出创意（RTB）
     *
     * @param resourceLocationId
     * @param ideaList
     * @param bidFlowFeature
     * @param manualIdeaId 人工投放时，人工筛选的创意ID，算法投放时为空。
     * @return
     */
    AdxChoiceIdeaResult manualChoiceIdea(Long resourceLocationId, List<ResourceIdeaDto> ideaList, BidFlowFeature bidFlowFeature, Long manualIdeaId);

    /**
     * 算法1.0出创意（RTB）
     *
     * @param resourceLocationId
     * @param ideaList
     * @param bidFlowFeature
     * @return
     */
    AdxChoiceIdeaResult algChoiceIdea(Long resourceLocationId, List<ResourceIdeaDto> ideaList, BidFlowFeature bidFlowFeature);

    /**
     * 算法2.0出创意（RTB）
     *
     * @param resourceLocationId
     * @param ideaList
     * @param bidFlowFeature
     * @return
     */
    AdxChoiceIdeaResult algChoiceIdeaPlus(Long resourceLocationId, List<ResourceIdeaDto> ideaList, BidFlowFeature bidFlowFeature);

    /**
     * 算法dpa出创意（RTB）
     * @param resourceLocationId
     * @param ideaList
     * @param bidFlowFeature
     * @return
     */
    AdxChoiceIdeaResult algDpaChoiceIdea(Long resourceLocationId, List<ResourceIdeaDto> ideaList, BidFlowFeature bidFlowFeature);

    /**
     *
     * @param resourceLocationId
     * @return
     */
    AdxResourceRcmdDo getRTBResourceRCMDDoFromCache(Long resourceLocationId);



}
