package cn.com.duiba.tuia.algo.engine.api.req;

import cn.com.duiba.tuia.algo.engine.api.adx.MeituanAdvertDto;
import lombok.Data;
import java.io.Serializable;
import java.util.List;

@Data
public class MeiTuanBidPriceReq implements Serializable {

    private static final long serialVersionUID = 2080517338720772972L;

    /**
     * 广告位ID
     */
    private Long slotId;

    /**
     * 媒体id
     */
    private Long mediaId;

    /**
     * 广告位维度设置的目标分成比例
     */
    private Double slotShareRate;

    /**
     * 出券(个数)
     */
    private Integer advertCount;

    /**
     * 底价（单位：分）
     */
    private Double floorPrice;

    /**
     * 美团外卖媒体用的广告配置集合
     */
    private List<MeituanAdvertDto> meituanAdvertList;

    private Integer groupTag;

    /**
     * 头部流量竞价次序调价用户阈值
     */
    private Long headBidPriceReqThreshold;

    /**
     * 头部流量竞价次序调价策略ab测试分组标识
     */
    private Integer headBidPriceAbTestGroupTag;

    private String deviceId;

    /**
     * 美团获胜率提升策略ab分流标识
     */
    private Integer promoteWinRateTag;

    private String ctrRate;

    /**
     * ab分流标识符
     */
    private String abTestGroupTag;

    /**
     *  用户当日在美团的第3～5次竞价请求提价因子，默认1.00,盘古
     */
    private String liftFactor;

}
