package cn.com.duiba.tuia.algo.engine.api.adx;

import lombok.Data;

import java.io.Serializable;

@Data
public class AdxDirectPriceResult implements Serializable {

    private static final long serialVersionUID = -80289051545930244L;

    /**
     * 广告id
     */
    private Long advertId;

    /**
     * 素材ID
     */
    private Long materialId;

    /**
     * 算法调整后的返回给媒体的出价
     */
    private Double adxPrice;

    /**
     * 维稳因子
     */
    private Double roiFactor;

    /**
     * 算法策略调整前原始价格
     */
    private Double oriPrice;

    /**
     * 广告线预估 CTR
     */
    private Double ctr;

    /**
     * 广告线预估 CVR
     */
    private Double cvr;

    /**
     * ctr * 广告线原始cpc出价
     */
    private Double arpu;

    /**
     * arpu * 分成比例
     */
    private Double oriScore;

    /**
     * ctr * 调整后的adx出价price
     */
    private Double score;

    /**
     * 0---命中白名单，对照组
     * 1---命中白名单，实验组
     * 2---未命中白名单
     */
    private Integer cpcTest;

    /**
     * 计划维度设置的目标分成比例
     */
    private Double advShareRate;

    /**
     * 广告线 发券CPC价格
     */
    private Double advPrice;
}
