/**
 * Copyright (c) 2021, duiba.com.cn All Rights Reserved.
 */
package cn.com.duiba.tuia.algo.engine.api.adx.v4;

import lombok.Data;

import java.io.Serializable;

/**
 * 描述: 算法4.0执行结果
 *
 * @author guopengfei@duiba.com.cn
 * @version v1.0
 * @date 2021/4/7 10:10
 */
@Data
public class AlgoExecuteDTO implements Serializable {

    // AdIdeaDo 算法返回结果，重新组装本类

    private Long ideaId;

    private Long unitId;

    private Long bidPrice;

    /**
     * 探价因子分桶标记
     */
    private String level;

    /**
     * 维稳因子
     */
    private Double factor;

    /**
     * 投放状态：1=正常投放，2=广告位探量投放，3=计划冷启动探价
     */
    private Integer exploreType;

    /**
     * 是否开启计划冷启动探价：关闭=0，开启=1
     */
    private Integer coldStartExploreStatus;

    /**
     * 计划冷启动探价预算/分
     */
    private Long coldStartExploreFee;

}
