/**
 * Copyright (c) 2021, duiba.com.cn All Rights Reserved.
 */
package cn.com.duiba.tuia.algo.engine.api.adx.v4;

import lombok.Data;

import java.io.Serializable;

/**
 * 描述: 算法4.0执行结果
 *
 * @author guopengfei@duiba.com.cn
 * @version v1.0
 * @date 2021/4/7 10:10
 */
@Data
public class AlgoExecuteDTO implements Serializable {

    // AdIdeaDo 算法返回结果，重新组装本类

    private Long ideaId;

    private Long unitId;

    private Long bidPrice;

    /**
     * 探价因子分桶标记
     */
    private String level;

    /**
     * 维稳因子
     */
    private Double factor;

    /**
     * 投放状态：1=正常投放，2=广告位探量投放，3=计划冷启动探价
     */
    private Integer exploreType;

    /**
     * 是否开启计划冷启动探价：关闭=0，开启=1
     */
    private Integer coldStartExploreStatus;

    /**
     * 计划冷启动探价预算/分
     */
    private Long coldStartExploreFee;

    /**
     * 预估ctr
     */
    private Double preCtr;

    /**
     * 统计ctr
     */
    private Double statCtr;

    /**
     * 融合ctr
     */
    private Double ctr;

    /**
     * 预估pv
     */
    private Double preLaunchPv;

    /**
     * 统计pv
     */
    private Double statLaunchPv;

    /**
     * 融合pv
     */
    private Double launchPv;

    /**
     * 预估arpu
     */
    private Double preArpu;

    /**
     * 统计arpu
     */
    private Double arpu;

    /**
     * 融合arpu
     */
    private Double mixArpu;

    /**
     * 预估clickPv
     */
    private Double preClickPv;

    /**
     * 统计clickPv
     */
    private Double statClickPv;

    /**
     * 融合clickPv
     */
    private Double mergeClickPv;

    /**
     * 预估adCpc
     */
    private Double preAdCpc;

    /**
     * 统计adCpc
     */
    private Double statAdCpc;

    /**
     * 融合adCpc
     */
    private Double mergeAdCpc;

    /**
     * 流量是否放弃（PD/PDB流量专用）
     * PD流量：0--不放弃；1--放弃
     * PDB流量：0--不放弃
     * RTB流量：不使用
     */
    private Integer isGiveUp;

    private Integer adxLaunchType;

    private Double mergeCvr;

    private Double preCvr;

    private Double statCvr;

    private Long flcAdvertId;

    private Double userScore;
}
