package cn.com.duiba.tuia.algo.engine.api.enums;

import cn.com.duiba.tuia.adx.center.api.enums.IdeaBidTypeEnum;
import lombok.Getter;

import java.util.stream.Stream;

/**
 * @author jiangyangyang
 * @version 1.0
 * @description: TODO 竞价类型
 * @date 2022/3/22 下午1:53
 */
@Getter
public enum BidTypeEnum {

    INTERACT(0, "interactAlgoRecommend", "互动"),

    DIRECTLY(1, "directlyAlgoRecommend","直投");

    private Integer code;

    private String name;

    private String remark;

    BidTypeEnum(Integer code, String name, String remark) {
        this.code = code;
        this.name = name;
        this.remark = remark;
    }

    /**
     * 根据编码获取竞价类型
     *
     * @param code
     * @return
     */
    public static BidTypeEnum findByCode(Integer code){
        if(code == null){
            return null;
        }
        return Stream.of(BidTypeEnum.values()).filter(e -> e.getCode().equals(code))
                .findFirst().orElse(null);
    }
}
