package cn.com.duiba.tuia.algo.engine.api.adx;

import cn.com.duiba.tuia.algo.engine.api.enums.MediaROIGroupTagEnum;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

@Data
public class GroupTagInfo implements Serializable {

    /**
     * 流量分组标识
     */
    private Integer flowGroupTag;

    /**
     * 点击价值预估模型分组标识
     */
    private Integer clickModeGroupTag;

    /**
     * 百度联盟、爱奇艺竞价次序调价策略分组标识
     */
    private Integer bidSuqAdjustPriceGroupTag;

    /**
     * 每pv发券模型分流key
     */
    private Integer launchPvShuntGroupTag;

    /**
     * 分媒体控制策略分组标识
     */
    private Integer mediaRoiGroupTag = MediaROIGroupTagEnum.LOGIC3.getCode();

    /**
     * 直投拓量测试分流标识符
     */
    private Integer directPlusGroupTag;

    /**
     * ADX算法4.0
     */
    private Integer algoV4GroupTag;

    /**
     * 预估模型联盟媒体id拼接规则变更
     */
    private Integer appIdAppendGroupTag;

    /**
     * ADX挑量（探价）策略分流标识
     */
    private Integer explorePriceGroupTag;

    /**
     * 新架构每pv发券模型分流
     */
    private Integer algoV4ModelGroupTag;

    /**
     * 区分4G用户分流
     */
    private Integer network;

    /**
     * 新架构ARPU模型分流
     */
    private Integer algoV4ArpuModelGroupTag;

    /**
     * 计划冷启动分流
     */
    private Integer coldStartGroupTag;

    /**
     * 流量初筛分流
     */
    private Integer flowScreenGroupTag;

    /**
     * 实验组元信息
     */
    private List<AbTestPlan> abTestPlanList;

    @Data
    public static class AbTestPlan implements Serializable {
        /**
         * 实验计划id
         */
        private String testPlanId;

        /**
         * 实验计划组id
         */
        private Integer testGroupId;

        /**
         * 实验层code
         */
        private String layerCode;
    }

}
