package cn.com.duiba.tuia.algo.engine.api.enums;

import lombok.Getter;

import java.util.stream.Stream;

/**
 * @author jiangyangyang
 * @version 1.0
 * @description: TODO 竞价类型
 * @date 2022/3/22 下午1:53
 */
@Getter
public enum RecommendTypeEnum {

    INTERACT(0, "interactAlgoRecommend", "互动"),

    DIRECTLY(1, "directlyAlgoRecommend","直投"),

    CPS(2, "cpsAlgoRecommend", "cps"),

    PDB(3, "pdbAlgoRecommend", "pdb");

    private Integer code;

    private String name;

    private String remark;

    RecommendTypeEnum(Integer code, String name, String remark) {
        this.code = code;
        this.name = name;
        this.remark = remark;
    }

    /**
     * 根据编码获取竞价类型
     *
     * @param code
     * @return
     */
    public static RecommendTypeEnum findByCode(Integer code){
        if(code == null){
            return null;
        }
        return Stream.of(RecommendTypeEnum.values()).filter(e -> e.getCode().equals(code))
                .findFirst().orElse(null);
    }
}
