/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.commercial.center.api.constant;

import cn.com.duiba.tuia.commercial.center.api.dto.plant.PlantSeedDto;
import java.util.Objects;
import org.apache.commons.lang3.RandomUtils;

public enum PlantSeedType {
    SEED_ONE(1, 10, 10, "0~1\u5143\u7ea2\u5305"),
    SEED_FIVE(5, 5, 20, "0~5\u5143\u7ea2\u5305"),
    SEED_TEN(10, 3, 30, "0~10\u5143\u7ea2\u5305"),
    SEED_IPHONE(20, 1, 50, "0~iPhone\u7ea2\u5305");

    private Integer type;
    private Integer stock;
    private Integer cost;
    private String desc;

    private PlantSeedType(Integer type, Integer stock, Integer cost, String desc) {
        this.type = type;
        this.stock = stock;
        this.cost = cost;
        this.desc = desc;
    }

    public Integer getType() {
        return this.type;
    }

    public Integer getStock() {
        return this.stock;
    }

    public Integer getCost() {
        return this.cost;
    }

    public String getDesc() {
        return this.desc;
    }

    public int countMatureTime(int times) {
        int matureTime = 0;
        switch (this) {
            case SEED_ONE: {
                if (times <= 3) {
                    matureTime = RandomUtils.nextInt((int)2, (int)4);
                    break;
                }
                if (times <= 6) {
                    matureTime = RandomUtils.nextInt((int)5, (int)11);
                    break;
                }
                matureTime = RandomUtils.nextInt((int)60, (int)601);
                break;
            }
            case SEED_FIVE: {
                matureTime = RandomUtils.nextInt((int)1200, (int)2401);
                break;
            }
            case SEED_TEN: {
                matureTime = RandomUtils.nextInt((int)3600, (int)7201);
                break;
            }
            case SEED_IPHONE: {
                matureTime = RandomUtils.nextInt((int)10800, (int)18001);
                break;
            }
        }
        return matureTime;
    }

    public static PlantSeedType valueOf(Integer type) {
        for (PlantSeedType typeEnum : PlantSeedType.values()) {
            if (!Objects.equals(typeEnum.getType(), type)) continue;
            return typeEnum;
        }
        return null;
    }

    public PlantSeedDto toDto() {
        PlantSeedDto seedDto = new PlantSeedDto();
        seedDto.setSeedType(this.getType());
        seedDto.setUnlock(false);
        seedDto.setStock(this.getStock());
        return seedDto;
    }
}

