/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.commercial.center.api.util;

import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class RegexUtil {
    private static final String REGEX_MOBILE_USER_AGENT = "Mobile|Android|webOS|iPhone|iPad|iPod|BlackBerry|UCWEB";
    private static final String REGEX_LAN_IP = "(127[.]0[.]0[.]1)|(localhost)|(10[.]\\d{1,3}[.]\\d{1,3}[.]\\d{1,3})|(172[.]((1[6-9])|(2\\d)|(3[01]))[.]\\d{1,3}[.]\\d{1,3})|(192[.]168[.]\\d{1,3}[.]\\d{1,3})";

    public static boolean isMobileUA(String userAgent) {
        if (StringUtils.isBlank((CharSequence)userAgent)) {
            return false;
        }
        return Pattern.compile(REGEX_MOBILE_USER_AGENT, 2).matcher(userAgent).find();
    }

    public static boolean isLAN(String ip) {
        if (StringUtils.isBlank((CharSequence)ip)) {
            return false;
        }
        return Pattern.compile(REGEX_LAN_IP, 2).matcher(ip).find();
    }
}

