package cn.com.duiba.tuia.commercial.center.api.cache;

/**
 * StoryCachedKeyUtils
 *
 * @author huangruodan
 * @date 2019/5/24
 */


public class StoryCachedKeyUtils {

    /** The prefix. */
    private static String prefix = "story";

    /**
     * The Constructor.
     */
    private StoryCachedKeyUtils() {

    }

    /**
     * Gets the prefix.
     *
     * @return the prefix
     */
    public static String getPrefix() {
        return prefix;
    }

    /**
     * Sets the prefix.
     *
     * @param prefix the prefix
     */
    public static void setPrefix(String prefix) {
        StoryCachedKeyUtils.prefix = prefix;
    }

    /**
     * 获取redis缓存key.
     *
     * @param key CacheKey中定义的缓存key标识
     * @param params 需要加到key中的参数列表
     * @return redis key
     */
    public static String getRedisKey(String key, Object... params) {
        StringBuilder redisKey = new StringBuilder(getPrefix() + key);

        for (Object param : params) {
            redisKey.append("-" + param);
        }

        return redisKey.toString();
    }
}
