/*
 * CSVDto.java
 * Copyright 2019 Qunhe Tech, all rights reserved.
 * Qunhe PROPRIETARY/CONFIDENTIAL, any form of usage is subject to approval.
 */
package cn.com.duiba.tuia.commercial.center.api.common;

import java.io.Serializable;

/**
 * ClassName: CSVDto <br/>
 * Function: csv格式数据. <br/>
 * Reason: 生成最终数据. <br/>
 * date: 2017年5月16日 下午5:26:27 <br/>
 *
 * @author wubo
 * @version
 * @since JDK 1.7
 */
public class CSVDto implements Serializable {

    private static final long  serialVersionUID = 1L;

    public static final String COMMA            = ",";
    public static final String LINE             = "\r\n";

    private String             date;

    private Integer            nextPage;

    private Integer            switches;

    public CSVDto() {
        this.nextPage = 1;
    }

    public CSVDto(String date, Integer nextPage, Integer switches) {
        this.date = date;
        this.nextPage = nextPage;
        this.switches = switches;
    }

    public String getDate() {
        return date;
    }

    public void setDate(String date) {
        this.date = date;
    }

    public Integer getNextPage() {
        return nextPage;
    }

    public void setNextPage(Integer nextPage) {
        this.nextPage = nextPage;
    }

    public boolean hasNext() {
        return nextPage != null;
    }

    public Integer getSwitches() {
        return switches;
    }

    public void setSwitches(Integer switches) {
        this.switches = switches;
    }

}
