/*
 * ActivityOptionType.java
 * Copyright 2019 Qunhe Tech, all rights reserved.
 * Qunhe PROPRIETARY/CONFIDENTIAL, any form of usage is subject to approval.
 */

package cn.com.duiba.tuia.commercial.center.api.constant;

import java.util.HashSet;
import java.util.Set;

/**
 * ClassName: ActivityOptionType <br/>
 * Function: 奖项类型枚举. <br/>
 * date: 2017年1月13日 下午2:53:09 <br/>
 *
 * @author wubo
 * @version 1.0
 * @since JDK 1.7
 */
public enum ActivityOptionType {

    TYPE_COUPON("coupon", "优惠券"), TYPE_LUCKY("lucky", "福袋"), TYPE_NOTHING("nothing", "不关联奖品"),
    TYPE_THANKS("thanks", "谢谢参与"), TYPE_AGAIN("again", "再来一次") ,TYPE_PHYSICAL("physical","实物"),
    TYPE_ALIPAY("alipay", "支付宝直充"),TYPE_VIRTUAL("virtual","虚拟奖品"),TYPE_QB("qb","Q币"),TYPE_BILL("bill","话费"),
    TYPE_RANDOM_COIN("randomCoin","随机金币")//友推使用
    ;
         
    
    /** code:奖项类型. */
    private String code;

    /** desc:奖项类型描述. */
    private String desc;

    ActivityOptionType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    /**
     * getCode:(奖项type). <br/>
     * 
     * @return String
     */
    public String getCode() {
        return code;
    }

    /**
     * getDesc:(奖项type描述). <br/>
     * 
     * @return String
     */
    public String getDesc() {
        return desc;
    }

    public boolean equalsCode(String type) {
        return code.equals(type);
    }

    /**
     * getDescByCode:(根据code获取描述). <br/>
     * 
     * @param code
     * @return
     */
    public static String getDescByCode(String code) {
        String desc = "";
        for (ActivityOptionType temp : ActivityOptionType.values()) {
            if (temp.getCode().equals(code)) {
                desc = temp.getDesc();
            }
        }
        return desc;
    }

    public static ActivityOptionType getByCode(String code){
        for (ActivityOptionType temp : ActivityOptionType.values()) {
            if (temp.getCode().equals(code)) {
                return temp;
            }
        }
        return null;
    }

    private static Set<String> stockType = new HashSet<>();
    static{
        stockType.add(TYPE_COUPON.code);
        stockType.add(TYPE_ALIPAY.code);
        stockType.add(TYPE_PHYSICAL.code);
        stockType.add(TYPE_VIRTUAL.code);
        stockType.add(TYPE_QB.code);
        stockType.add(TYPE_BILL.code);
    }

    /**
     * 是否是 有库存的奖项类型
     * @param type
     * @return
     */
    public static boolean isStockType(String type) {
        return stockType.contains(type);
    }

}
