/*
 * AlipayOrderStatus.java
 * Copyright 2019 Qunhe Tech, all rights reserved.
 * Qunhe PROPRIETARY/CONFIDENTIAL, any form of usage is subject to approval.
 */

package cn.com.duiba.tuia.commercial.center.api.constant;

/**
 * Created by wubo on 2017/7/10.
 * 支付宝订单 状态枚举
 */
public enum AlipayOrderStatus {

    NULL(0,"无状态","无状态","无状态","无状态"),
    DEALING(1, "处理中", "信息未填写","待处理", "待处理"),
    SUCCESS(2, "转账成功", "已完成",null, null),
    CONSUMER_ERROR(3, "用户账户异常", "账户错误", "异常", "异常,账户信息错误"),
    SYSTEM_ERROR(4, "非用户异常", "处理中", "异常", "异常"),
    OVERDUE(5, "逾期未领取", "已关闭,逾期未领取", null, null),
    FORCE_CLOSE(6, "强制关闭", "已完成", "已完成，强制成功", null),
    TRANSFER(7, "转账中", "处理中", "待处理", "待处理"),
    DELETED(8, "删除态", "订单错误", "订单已删除", "订单已删除"),
    NEED_SEND(9, "待发货", "处理中", "待处理", "待发货"),
    WAIT_CALL_BACK(10, "等待接口回调", "处理中", "待处理", "待处理");

    /**
     * 正常订单 集合
     */
    private static Integer[] normalStatus = {DEALING.getStatus(), SUCCESS.getStatus(), OVERDUE.getStatus(),
            FORCE_CLOSE.getStatus(), TRANSFER.getStatus(),NEED_SEND.getStatus(),WAIT_CALL_BACK.status};

    /**
     * 异常订单 集合
     */
    private static Integer[] errorStatus = {CONSUMER_ERROR.getStatus(), SYSTEM_ERROR.getStatus()};

    /**
     * 完成订单 集合
     */
    private static Integer[] finishedStatus = { SUCCESS.getStatus(), FORCE_CLOSE.getStatus() };
    private Integer status;
    private String statusType;
    private String userTip;
    private String adminTip;
    private String mediaTip;

    AlipayOrderStatus(Integer status, String statusType, String userTip, String adminTip, String mediaTip) {
        this.status = status;
        this.userTip = userTip;
        this.adminTip = null == adminTip? userTip:adminTip;
        this.statusType = statusType;
        this.mediaTip = null == mediaTip? userTip:mediaTip;
    }

    public static Integer[] normalStatus() {
        return normalStatus;
    }

    public static Integer[] errorStatus() {
        return errorStatus;
    }

    public static Integer[] finishedStatus() {
        return finishedStatus;
    }

    public Integer getStatus() {
        return status;
    }

    public String getUserTip() {
        return userTip;
    }

    public String getAdminTip() {
        return adminTip;
    }

    public String getStatusType() {
        return statusType;
    }

    public String getMediaTip() {
        return mediaTip;
    }

    public static AlipayOrderStatus getEnumByStatus(Integer status) {
        for (AlipayOrderStatus s : AlipayOrderStatus.values()) {
            if (s.status.equals(status)) {
                return s;
            }
        }
        return NULL;
    }
}
