/*
 * HttpProperty.java
 * Copyright 2019 Qunhe Tech, all rights reserved.
 * Qunhe PROPRIETARY/CONFIDENTIAL, any form of usage is subject to approval.
 */
package cn.com.duiba.tuia.commercial.center.api.constant;

/**
 * ClassName: HttpProperty <br/>
 * Function: http参数类型. <br/>
 * Reason: url,head,body. <br/>
 * date: 2017年4月17日 上午11:37:49 <br/>
 *
 * @author wubo
 * @version
 * @since JDK 1.7
 */
public enum HttpProperty {

    URL(0, "url"), HEAD(1, "head"), BODY(2, "body"),HIDE(3,"hide");

    /** type:数据库存储使用此值. */
    private Integer type;

    /** code:. */
    private String  code;

    /**
     * Creates a new instance of HttpProperty.
     *
     * @param type
     * @param code
     */

    private HttpProperty(Integer type, String code) {
        this.type = type;
        this.code = code;
    }

    public Integer getType() {
        return type;
    }

    public String getCode() {
        return code;
    }

}
