package cn.com.duiba.tuia.commercial.center.api.constant;

import java.util.Objects;

/**
 * [种红包V2]任务条件类型枚举
 *
 * @author zhangbaiqiang
 * @date 2018/12/17
 */
public enum PlantMissionConditionType {

    LOGIN(1, "LOGIN", "登录"),
    PLANT(2, "PLANT", "种"),
    PICK(3, "PICK", "收"),
    CONTINUOUS_LOGIN(4, "CONTINUOUS_LOGIN", "连续登录"),
    ;

    /**
     * 类型
     */
    private Integer type;

    /**
     * 键名
     */
    private String key;

    /**
     * 描述
     */
    private String  desc;

    PlantMissionConditionType(Integer type, String key, String desc) {
        this.type = type;
        this.key = key;
        this.desc = desc;
    }

    public Integer getType() {
        return type;
    }

    public String getKey() {
        return key;
    }

    public String getDesc() {
        return desc;
    }

    /**
     * 获取任务的枚举
     *
     * @param key 任务类型键名
     * @return 枚举
     */
    public static PlantMissionConditionType getByKey(String key) {
        for (PlantMissionConditionType typeEnum : values()) {
            if (Objects.equals(typeEnum.getKey(), key)) {
                return typeEnum;
            }
        }
        return null;
    }
}
