/**
 * 文件名： BaseDO.java 此类描述的是： 作者: leiliang 创建时间: 2016年4月1日 上午11:47:03
 */
package cn.com.duiba.tuia.commercial.center.api.dto;

import cn.com.duiba.wolf.utils.DateUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;

import java.io.Serializable;
import java.util.Calendar;

/**
 * 基础do.
 *
 * @author: leiliang
 * @version:
 */
public class PeriodDto implements Serializable {

    /**
     * @since JDK 1.6
     */
    private static final long serialVersionUID = 691928415784046944L;

    /** 开始时间. */
    protected String          start;

    /** 结束时间. */
    protected String          end;

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

    public String getStart() {
        return start;
    }

    public Calendar getDateStart() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(DateUtils.getMinuteOnlyDate(start));
        return calendar;
    }

    public void setStart(String start) {
        this.start = start;
    }

    public String getEnd() {
        return end;
    }

    public Calendar getDateEnd() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(DateUtils.getMinuteOnlyDate(end));
        return calendar;
    }

    public void setEnd(String end) {
        this.end = end;
    }

}
