/*
 * CommercialCenterException.java
 * Copyright 2019 Qunhe Tech, all rights reserved.
 * Qunhe PROPRIETARY/CONFIDENTIAL, any form of usage is subject to approval.
 */

package cn.com.duiba.tuia.commercial.center.api.exception;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.tuia.commercial.center.api.constant.ErrorCode;

public class CommercialCenterException extends BizException implements CommercialCenterBaseException {
    private static final long serialVersionUID = -6333334255587845313L;

    private String code;

    public CommercialCenterException(ErrorCode errorCode) {
        super(errorCode.getDesc());
        this.code = errorCode.getErrorCode();
    }

    public CommercialCenterException(String code, String msg) {
        super(msg);
        this.code = code;
    }

    public String getCode() {
        return code;
    }

}
