/*
 * InnerLog.java
 * Copyright 2019 Qunhe Tech, all rights reserved.
 * Qunhe PROPRIETARY/CONFIDENTIAL, any form of usage is subject to approval.
 */

package cn.com.duiba.tuia.commercial.center.api.log;

import cn.com.duiba.wolf.utils.DateUtils;
import cn.com.duiba.wolf.utils.UUIDUtils;

import java.util.Date;

/**
 * ClassName: InnerLog <br/>
 * Function: 内部日志. <br/>
 * 内部日志分配参考 http://cf.dui88.com/pages/viewpage.action?pageId=4499963 <br/>
 * date: 2017年2月23日 下午6:47:44 <br/>
 *
 * @author wubo
 * @version
 * @since JDK 1.7
 */
public class InnerLog extends Log {

    /**
     * GROUP=1 广告平台业务
     */
    public static final int ADVERT_GROUP  = 1;

    /**
     * TYPE=13 活动信息操作记录
     */
    public static final int ACTIVITY_TYPE = 13;

    /**
     * Creates a new instance of InnerLog.
     *
     */
    public InnerLog() {
        super();
        put("uuid",UUIDUtils.createSecureUUID());
        put("time", DateUtils.getSecondStr(new Date()));
    }

    /**
     * group:(日志业务分组). <br/>
     * 
     * @param group
     * @return
     */
    public InnerLog group(int group) {
        put("group", group);
        return this;
    }

    /**
     * type:(日志类型). <br/>
     * 
     * @param type
     * @return
     */
    public InnerLog type(int type) {
        put("type", type);
        return this;
    }

    /**
     * dpm:(位置信息). <br/>
     * 
     * @param dpm
     * @return
     */
    public InnerLog dpm(String dpm) {
        put("dpm", dpm);
        return this;
    }

    /**
     * dcm:(内容信息). <br/>
     * 
     * @param dcm
     * @return
     */
    public InnerLog dcm(String dcm) {
        put("dcm", dcm);
        return this;
    }
}
