/*
 * TuiaCommercialLog.java
 * Copyright 2019 Qunhe Tech, all rights reserved.
 * Qunhe PROPRIETARY/CONFIDENTIAL, any form of usage is subject to approval.
 */

package cn.com.duiba.tuia.commercial.center.api.log;

import cn.com.duiba.wolf.utils.DateUtils;

import java.util.Date;

/**
 * ClassName: TuiaCommercialLog <br/>
 * Function: 推啊活动操作日志. <br/>
 * date: 2017年2月23日 下午5:53:22 <br/>
 *
 * @author wubo
 * @version
 * @since JDK 1.7
 */
public class TuiaCommercialLog extends Log {

    /**
     * Creates a new instance of TuiaCommercialLog.
     *
     */
    public TuiaCommercialLog() {
        super();
        put("time", DateUtils.getSecondStr(new Date()));
    }

    /**
     * activityId:(活动id). <br/>
     * 
     * @param activityId
     * @return TuiaCommercialLog
     */
    public TuiaCommercialLog activityId(long activityId) {
        put("activityId", activityId);
        return this;
    }

    /**
     * title:(活动名称). <br/>
     * 
     * @param title
     * @return TuiaCommercialLog
     */
    public TuiaCommercialLog title(String title) {
        put("title", title);
        return this;
    }

    /**
     * activityType:(活动类型). <br/>
     * 
     * @param activityType
     * @return TuiaCommercialLog
     */
    public TuiaCommercialLog activityType(Integer activityType) {
        put("activityType", activityType);
        return this;
    }

    /**
     * limitCount:(参与次数). <br/>
     * 
     * @param limitCount
     * @return TuiaCommercialLog
     */
    public TuiaCommercialLog limitCount(Integer limitCount) {
        put("limitCount", limitCount);
        return this;
    }

    /**
     * tag:(标签). <br/>
     * 
     * @param tag
     * @return TuiaCommercialLog
     */
    public TuiaCommercialLog tag(String tag) {
        put("tag", tag);
        return this;
    }

    /**
     * action:(操作动作). <br/>
     * 
     * @param action
     * @return TuiaCommercialLog
     */
    public TuiaCommercialLog action(String action) {
        put("action", action);
        return this;
    }
}
