package cn.com.duiba.tuia.commercial.center.api.remoteservice.commercial.plant;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.commercial.center.api.dto.commercial.CommercialUserReq;
import cn.com.duiba.tuia.commercial.center.api.dto.commercial.mission.req.FinishMissionReq;
import cn.com.duiba.tuia.commercial.center.api.dto.commercial.plant.LotteryDto;
import cn.com.duiba.tuia.commercial.center.api.dto.commercial.plant.PlantConfigDto;
import cn.com.duiba.tuia.commercial.center.api.dto.commercial.plant.PlantDto;
import cn.com.duiba.tuia.commercial.center.api.dto.commercial.plant.PropDto;
import cn.com.duiba.tuia.commercial.center.api.dto.commercial.plant.req.PlantPropReq;
import cn.com.duiba.tuia.commercial.center.api.dto.commercial.plant.req.PlantReq;
import cn.com.duiba.tuia.commercial.center.api.dto.commercial.plant.req.ResetForTestReq;

import java.util.List;

@AdvancedFeignClient
public interface RemotePlantV4Service {

    /**
     * 签到
     *
     * @param req 用户参数
     * @return 种红包所有信息
     * @throws BizException
     */
    PlantDto sign(CommercialUserReq req) throws BizException;

    /**
     * 种红包
     *
     * @param plantReq 用户参数、土地编号、种子类型
     * @return 用户信息、土地信息、种子仓库
     * @throws BizException
     */
    PlantDto plant(PlantReq plantReq) throws BizException;

    /**
     * 采摘红包
     *
     * @param plantReq    用户参数、种子编号
     * @return 用户信息，奖励信息
     * @throws BizException
     */
    PlantDto pick(PlantReq plantReq) throws BizException;

    /**
     * 领取任务奖励
     *
     * @param missionReq  用户参数、任务编号
     * @return 用户信息，奖励信息
     */
    PlantDto finishMission(FinishMissionReq missionReq) throws BizException;

    /**
     * 获取种红包奖励配置
     *
     * @return 种红包奖励配置
     */
    PlantConfigDto queryPrizeConfig() throws BizException;

    /**
     * 更新奖励配置参数(慎用)
     *
     * @param configDto 奖励配置对象
     * @return 是否更新成功
     */
    boolean updatePlantConfig(PlantConfigDto configDto) throws BizException;

    /**
     * 用户使用道具，
     *
     * @param propReq req、landId、propType
     * @throws BizException
     */
    PropDto useProp(PlantPropReq propReq) throws BizException;

    /**
     * @param req
     * @return
     * @throws BizException
     */
    LotteryDto lotteryEveryday(CommercialUserReq req) throws BizException;


    /**
     * @param req
     * @return
     * @throws BizException
     */
    int finishVat(CommercialUserReq req) throws BizException;

    /**
     * 换天接口
     * @param req deviceId、appId、date
     * @return
     * @throws BizException
     */
    Boolean resetForTest(ResetForTestReq req) throws BizException;

    /**
     * 获取浮标显示天数
     * @param activityId
     * @return
     */
    List<Integer> getBouyShowDays(Long activityId);

    /**
     * 设置浮标天数
     * @param activityId
     * @param showDaysStr
     * @return
     */
    boolean setBouyShowDays(Long activityId, String showDaysStr);

}
