package cn.com.duiba.tuia.commercial.center.api.remoteservice.story;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.commercial.center.api.dto.commercial.plant.req.ResetForTestReq;
import cn.com.duiba.tuia.commercial.center.api.dto.story.StoryUserReq;
import cn.com.duiba.tuia.commercial.center.api.dto.story.plant.req.StoryFinishMissionReq;
import cn.com.duiba.tuia.commercial.center.api.dto.story.plant.req.StoryPlantReq;
import cn.com.duiba.tuia.commercial.center.api.dto.story.tree.TreeAlbumDetailDto;
import cn.com.duiba.tuia.commercial.center.api.dto.story.tree.TreeDto;
import cn.com.duiba.tuia.commercial.center.api.dto.story.tree.finance.TreeRewardDto;

/**
 * [深度互动故事完整性] 种树接口
 * RemoteStoryTreeService
 *
 * @author huangruodan
 * @date 2019/6/6
 */
@AdvancedFeignClient
public interface RemoteStoryTreeService {

    /**
     * 签到
     *
     * @param req 用户参数
     * @return 用户信息、土地信息、种子仓库、签到信息
     */
    TreeDto sign(StoryUserReq req) throws BizException;

    /**
     * 种果实
     *
     * @param plantReq req 用户参数 landId 位置编号
     * @return 用户信息，奖励信息
     */
    TreeDto plant(StoryPlantReq plantReq) throws BizException;

    /**
     * 收果实
     *
     * @param plantReq req  用户参数 fruitId 种子编号
     * @return 用户信息，奖励信息
     */
    TreeDto pick(StoryPlantReq plantReq) throws BizException;

    /**
     * 领取任务奖励
     *
     * @param missionReq req 用户参数 missionId 任务编号
     * @return 用户信息，奖励信息
     */
    TreeDto finishMission(StoryFinishMissionReq missionReq) throws BizException;

    /**
     * 种一棵树
     *
     * @param req 用户参数
     * @return 用户信息
     */
    TreeDto plantTree(StoryUserReq req) throws BizException;

    /**
     * 果树图鉴
     * @param req 用户参数
     * @return 果树图鉴
     * @throws BizException 业务异常
     */
    TreeAlbumDetailDto getTreeAlbumDetail(StoryUserReq req) throws BizException;

    /**
     * 用户互动游戏
     * @param req 用户请求参数
     * @return 奖励类型
     * @throws BizException 业务异常
     */
    TreeRewardDto userInteractiveReward(StoryUserReq req) throws BizException;

    /**
     * 修改黄金采摘期的时间
     */
    boolean updateGoldPick(ResetForTestReq req) throws BizException;
}
