package cn.com.duiba.tuia.commercial.center.api.remoteservice.story;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.commercial.center.api.dto.commercial.plant.req.ResetForTestReq;
import cn.com.duiba.tuia.commercial.center.api.dto.story.StoryUserReq;
import cn.com.duiba.tuia.commercial.center.api.dto.story.user.StoryUserDto;

import java.util.List;

/**
 * [深度互动故事完整性] 用户接口
 * RemoteStoryUserService
 *
 * @author huangruodan
 * @date 2019/5/29
 */
@AdvancedFeignClient
public interface RemoteStoryUserService {

    /**
     * 查询用户信息，若没有则新建
     * @param storyUserReq 用户信息
     * @return 基础用户信息
     * @throws BizException 用户信息获取失败
     */
    StoryUserDto queryOrCreateStoryUser(StoryUserReq storyUserReq) throws BizException;

    /**
     * 更新用户信息
     * @param storyUser 用户
     * @return 是否成功
     * @throws BizException 业务异常
     */
    Boolean updateStoryUser(StoryUserDto storyUser) throws BizException;

    /**
     * [测试用接口]清除缓存
     *
     * @param req deviceId 设备id 媒体id 签到日期 活动类型
     */
    Boolean resetForTest(ResetForTestReq req) throws BizException;

    /**
     * 查询媒体最近的100位新用户
     *
     * @param appId 媒体id
     * @return 用户信息
     */
    List<StoryUserDto> queryNewUsers(Long appId);
}
