package cn.com.duiba.tuia.commercial.center.api.dto.commercial.mission;

import cn.com.duiba.tuia.commercial.center.api.dto.commercial.user.req.CommercialUserReq;
import cn.com.duiba.tuia.commercial.center.api.dto.commercial.dig.DigUserDto;
import cn.com.duiba.tuia.commercial.center.api.dto.commercial.user.BizActivityUserDto;

import java.io.Serializable;

/**
 * [商业化活动]任务列表构建参数
 *
 * @author zhangbaiqiang
 * @date 2019-03-13
 */
public class MissionParamsBuilder implements Serializable {
    private static final long serialVersionUID = 2736676364057551904L;

    /**
     * 用户参数
     */
    private CommercialUserReq userReq;

    /**
     * 活动用户信息
     */
    private BizActivityUserDto activityUserDto;

    /**
     * 挖矿用户信息
     */
    private DigUserDto digUserDto;

    /**
     * [种红包]当日种红包次数
     */
    private int curPlantTimes;

    /**
     * [种红包]当日收红包次数
     */
    private int curPickTimes;

    /**
     * 当前连续任务进度
     */
    private int curEnterCaveProgess;

    /**
     * 用户当日打开宝箱次数
     */
    private int openTreasureBoxs;


    /**
     * 用户当日挖矿次数
     */
    private int curDigTimes;

    /*
     * 用户今日增值弹窗任务的状态 0-未开启 1-开启未完成 2-已完成
     * */
    private int vatMissionStatus;

    public int getVatMissionStatus() {
        return vatMissionStatus;
    }

    public MissionParamsBuilder setVatMissionStatus(int vatMissionStatus) {
        this.vatMissionStatus = vatMissionStatus;
        return this;
    }

    public CommercialUserReq getUserReq() {
        return userReq;
    }

    public MissionParamsBuilder setUserReq(CommercialUserReq userReq) {
        this.userReq = userReq;
        return this;
    }

    public BizActivityUserDto getActivityUserDto() {
        return activityUserDto;
    }

    public MissionParamsBuilder setActivityUserDto(BizActivityUserDto activityUserDto) {
        this.activityUserDto = activityUserDto;
        return this;
    }

    public int getCurPlantTimes() {
        return curPlantTimes;
    }

    public MissionParamsBuilder setCurPlantTimes(int curPlantTimes) {
        this.curPlantTimes = curPlantTimes;
        return this;
    }

    public int getCurPickTimes() {
        return curPickTimes;
    }

    public MissionParamsBuilder setCurPickTimes(int curPickTimes) {
        this.curPickTimes = curPickTimes;
        return this;
    }

    public int getCurEnterCaveProgess() {
        return curEnterCaveProgess;
    }

    public MissionParamsBuilder setCurEnterCaveProgess(int curEnterCaveProgess) {
        this.curEnterCaveProgess = curEnterCaveProgess;
        return this;
    }

    public int getOpenTreasureBoxs() {
        return openTreasureBoxs;
    }

    public MissionParamsBuilder setOpenTreasureBoxs(int openTreasureBoxs) {
        this.openTreasureBoxs = openTreasureBoxs;
        return this;
    }

    public DigUserDto getDigUserDto() {
        return digUserDto;
    }

    public MissionParamsBuilder setDigUserDto(DigUserDto digUserDto) {
        this.digUserDto = digUserDto;
        return this;
    }

    public int getCurDigTimes() {
        return curDigTimes;
    }

    public MissionParamsBuilder setCurDigTimes(int curDigTimes) {
        this.curDigTimes = curDigTimes;
        return this;
    }
}
