package cn.com.duiba.tuia.commercial.center.api.remoteservice.commercial.richman;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.commercial.center.api.dto.richman.RichManMapDto;

import java.util.List;

/**
 * @author scd
 * @version 1.0
 * @since 2019-12-04 14:17
 */
@AdvancedFeignClient
public interface RemoteRichManMapService {

    /**
     * 获取用户的 当前地图
     * @param steps
     * @return
     */
    RichManMapDto getNowMapBySteps(Long steps);

    /**
     * 获取当前6格后的地图
     * @param steps
     * @return
     */
    List<RichManMapDto> getAfterMapBySteps(Long steps,Long afterSteps);

    /**
     * 获取城市配置的媒体奖励
     * @param name
     * @return
     */
    List<RichManMapDto> getMediaMapsByCityName(String name,Long steps);

    /**
     * 获取下一个城市媒体奖励
     * @param name
     * @return
     */
    List<RichManMapDto> getNextMapsByCityName(String name);


    /**
     * 获取前3个地图
     * @param nowSteps
     * @return
     */
    List<RichManMapDto> getBefore3Map(Long nowSteps);
}
