package cn.com.duiba.tuia.commercial.center.api.remoteservice.farm;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.commercial.center.api.dto.farm.FarmFruitConfigDto;

import java.util.List;

@AdvancedFeignClient
public interface RemoteFarmFruitConfigService {

    /**
     * 果实配置
     *
     * @param farmFruitConfigDto
     * @return
     * @throws BizException
     */
    Boolean saveFruitConfig(FarmFruitConfigDto farmFruitConfigDto) throws BizException;

    /**
     * 果实批量配置
     *
     * @param list
     * @return
     */
    Boolean fruitConfigBatch(List<FarmFruitConfigDto> list) throws BizException;

    /**
     * 更新配置
     *
     * @param farmFruitConfigDto
     * @return
     * @throws BizException
     */
    Boolean updateFruitConfig(FarmFruitConfigDto farmFruitConfigDto) throws BizException;

    /**
     * 获取果实配置接口
     *
     * @param appId 媒体id
     * @param level 果实等级
     * @param type  类型 cn.com.duiba.tuia.commercial.center.biz.constants.farm.fruit.enums.FruitType
     * @return FarmFruitConfigDto
     * @throws BizException
     */
    FarmFruitConfigDto getFruitConfig(Long appId, Integer level, Integer type) throws BizException;


    /**
     * 根据id删除
     *
     * @param id
     * @return
     */
    Boolean deleteById(Long id) throws BizException;

    /**
     * 根据appId删除
     *
     * @param appId
     * @return
     */
    Boolean deleteByApp(Long appId) throws BizException;
}
