package cn.com.duiba.tuia.commercial.center.api.dto.farm;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * FarmInitializeUserDto
 * 用户初始化信息类
 * @author huangruodan
 * @date 2019-11-21
 */

@Data
public class FarmInitializeUserDto implements Serializable {

    private static final long serialVersionUID = -2450940620431712354L;

    /**
     * ID
     */
    private Long id;

    /**
     * 用户金币数
     */
    private Long cash;

    /**
     * 红包数
     */
    private Integer redPacket;

    /**
     * 红包总数（包括已领取，已失效和已使用）
     */
    private Integer redPacketNum;

    /**
     * 登录天数
     */
    private Integer signDays;

    /**
     * 上次登录时间
     */
    private Date lastSignTime;

    /**
     * 是否今日首次登陆
     */
    private Boolean signFlag;

    /**
     * 采摘次数
     */
    private Integer pickTimes;

    /**
     * 当前采摘次数
     */
    private Integer curPickTimes;

    /**
     * 离线收益
     */
    private Long offlineCash;

    /**
     * 阶梯
     */
    private Integer stage;

    /**
     * IP
     */
    private String ip;

    /**
     * 果实升级次数
     */
    private Integer fruitUpgradeTimes;
}
