package cn.com.duiba.tuia.commercial.center.api.remoteservice.farm;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.commercial.center.api.dto.farm.FarmCommonDto;
import cn.com.duiba.tuia.commercial.center.api.dto.farm.FarmDto;
import cn.com.duiba.tuia.commercial.center.api.dto.farm.FarmWaterDto;
import cn.com.duiba.tuia.commercial.center.api.dto.farm.req.FarmWaterReq;

/**
 * [红包农场]灌溉
 * Created by xuefeng on 2019/12/5.
 */
@AdvancedFeignClient
public interface RemoteFarmWaterService {

    /**
     * 查询灌溉工具信息
     *
     * @param farmWaterReq
     * @return
     */
    FarmWaterDto queryWaterInfo(FarmWaterReq farmWaterReq) throws BizException;

    /**
     * 灌溉
     *
     * @param farmWaterReq
     * @return
     */
    FarmDto doWater(FarmWaterReq farmWaterReq) throws BizException;

    /**
     * 升级灌溉工具
     *
     * @param farmWaterReq
     * @return
     */
    FarmDto upgradeWater(FarmWaterReq farmWaterReq) throws BizException;
}
