package cn.com.duiba.tuia.commercial.center.api.dto.commercial.plant;

import cn.com.duiba.tuia.commercial.center.api.dto.commercial.common.StageDto;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * [商业化活动]种红包用户Dto
 *
 * @author zhangbaiqiang
 * @date 2019/03/08
 */
public class PlantUserDto implements Serializable {
    private static final long serialVersionUID = -4894933160489633071L;

    /**
     * 设备ID
     */
    private String deviceId;

    /**
     * 现金
     */
    private Long cash;

    /**
     * 签到天数
     */
    private Integer signDays;

    /**
     * 当天所在周期
     */
    private Integer stage;

    /**
     * 上次签到时间
     */
    private Date lastSignTime;

    /**
     * 已解锁土地
     */
    private Integer unlockLand;

    /**
     * 播种次数
     */
    private Integer plantTimes;

    /**
     * 采摘次数
     */
    private Integer pickTimes;

    /**
     * 当日采摘次数
     */
    private Integer curPickTimes;

    /**
     * 当日播种次数
     */
    private Integer curPlantTimes;
    /**
     * 提现次数
     */
    private Integer withdrawTimes;

    /**
     * 提现门槛
     */
    private Long withdrawThreshold;

    /**
     * 预算单位
     */
    private Integer unitType;

    /**
     * 保留小数位数
     */
    private Integer digits;

    /**
     * 虚拟货币名称
     */
    private String unitName;

    /**
     * 提现周期配置
     */
    private List<StageDto> stages;

    /**
     * 剩余转盘次数
     */
    private Integer lotteryTimes;

    /**
     * 增值任务宝箱 null 0-不显示 1-宝箱/红包 2-红包雨
     */
    private Integer vatTreasureChest;

    /**
     * 浮标展示天数列表
     */
    private List<Integer> buoyShowList;

    /**
     * 定制媒体积分消耗免费次数,
     */
    private Integer hbFreeTimes;

    /**
     * 定制媒体积分消耗分值
     */
    private Integer hbDeductScore;

    /**
     * 定制媒体剩余积分数量
     */
    private Integer hbPoint;

    /**
     * 恢复种红包倒计时，用于酷狗
     */
    private Long recoverPlantCountDown;

    /**
     * 定制用户类型 1、月光宝盒上线前创建用户 2、月光宝盒上线后创建用户
     */
    private Integer customizationUserType;

    /**
     * 今日是否已领取福利
     */
    private Boolean customizationCurRewardFlag;

    /**
     * 获得定制福利总次数
     */
    private Integer customizationRewardTimes;

    /**
     * 是否连续领取
     */
    private Boolean customizationContinuousFlag;


    /**
     * 定制倒计时
     */
    private Long customizationCountdown;

    /**
     * 剩余播种次数
     */
    private Integer remainPlantTimes;

    public Integer getRemainPlantTimes() {
        return remainPlantTimes;
    }

    public void setRemainPlantTimes(Integer remainPlantTimes) {
        this.remainPlantTimes = remainPlantTimes;
    }

    public Long getRecoverPlantCountDown() {
        return recoverPlantCountDown;
    }

    public void setRecoverPlantCountDown(Long recoverPlantCountDown) {
        this.recoverPlantCountDown = recoverPlantCountDown;
    }

    public Long getCustomizationCountdown() {
        return customizationCountdown;
    }

    public void setCustomizationCountdown(Long customizationCountdown) {
        this.customizationCountdown = customizationCountdown;
    }

    public Integer getCustomizationUserType() {
        return customizationUserType;
    }

    public void setCustomizationUserType(Integer customizationUserType) {
        this.customizationUserType = customizationUserType;
    }

    public Boolean getCustomizationCurRewardFlag() {
        return customizationCurRewardFlag;
    }

    public void setCustomizationCurRewardFlag(Boolean customizationCurRewardFlag) {
        this.customizationCurRewardFlag = customizationCurRewardFlag;
    }

    public Boolean getCustomizationContinuousFlag() {
        return customizationContinuousFlag;
    }

    public void setCustomizationContinuousFlag(Boolean customizationContinuousFlag) {
        this.customizationContinuousFlag = customizationContinuousFlag;
    }

    public Integer getCustomizationRewardTimes() {
        return customizationRewardTimes;
    }

    public void setCustomizationRewardTimes(Integer customizationRewardTimes) {
        this.customizationRewardTimes = customizationRewardTimes;
    }

    public String getDeviceId() {
        return deviceId;
    }

    public void setDeviceId(String deviceId) {
        this.deviceId = deviceId;
    }

    public Long getCash() {
        return cash;
    }

    public void setCash(Long cash) {
        this.cash = cash;
    }

    public Integer getSignDays() {
        return signDays;
    }

    public void setSignDays(Integer signDays) {
        this.signDays = signDays;
    }

    public Date getLastSignTime() {
        return lastSignTime;
    }

    public void setLastSignTime(Date lastSignTime) {
        this.lastSignTime = lastSignTime;
    }

    public Integer getUnlockLand() {
        return unlockLand;
    }

    public void setUnlockLand(Integer unlockLand) {
        this.unlockLand = unlockLand;
    }

    public Integer getPlantTimes() {
        return plantTimes;
    }

    public void setPlantTimes(Integer plantTimes) {
        this.plantTimes = plantTimes;
    }

    public Integer getPickTimes() {
        return pickTimes;
    }

    public void setPickTimes(Integer pickTimes) {
        this.pickTimes = pickTimes;
    }

    public Integer getWithdrawTimes() {
        return withdrawTimes;
    }

    public void setWithdrawTimes(Integer withdrawTimes) {
        this.withdrawTimes = withdrawTimes;
    }

    public Long getWithdrawThreshold() {
        return withdrawThreshold;
    }

    public void setWithdrawThreshold(Long withdrawThreshold) {
        this.withdrawThreshold = withdrawThreshold;
    }

    public Integer getStage() {
        return stage;
    }

    public void setStage(Integer stage) {
        this.stage = stage;
    }

    public List<StageDto> getStages() {
        return stages;
    }

    public void setStages(List<StageDto> stages) {
        this.stages = stages;
    }

    public Integer getCurPickTimes() {
        return curPickTimes;
    }

    public void setCurPickTimes(Integer curPickTimes) {
        this.curPickTimes = curPickTimes;
    }

    public Integer getCurPlantTimes() {
        return curPlantTimes;
    }

    public void setCurPlantTimes(Integer curPlantTimes) {
        this.curPlantTimes = curPlantTimes;
    }

    public Integer getUnitType() {
        return unitType;
    }

    public void setUnitType(Integer unitType) {
        this.unitType = unitType;
    }

    public Integer getDigits() {
        return digits;
    }

    public void setDigits(Integer digits) {
        this.digits = digits;
    }

    public String getUnitName() {
        return unitName;
    }

    public void setUnitName(String unitName) {
        this.unitName = unitName;
    }

    public Integer getLotteryTimes() {
        return lotteryTimes;
    }

    public void setLotteryTimes(Integer lotteryTimes) {
        this.lotteryTimes = lotteryTimes;
    }

    public Integer getVatTreasureChest() {
        return vatTreasureChest;
    }

    public void setVatTreasureChest(Integer vatTreasureChest) {
        this.vatTreasureChest = vatTreasureChest;
    }

    public List<Integer> getBuoyShowList() {
        return buoyShowList;
    }

    public void setBuoyShowList(List<Integer> buoyShowList) {
        this.buoyShowList = buoyShowList;
    }

    public Integer getHbFreeTimes() {
        return hbFreeTimes;
    }

    public void setHbFreeTimes(Integer hbFreeTimes) {
        this.hbFreeTimes = hbFreeTimes;
    }

    public Integer getHbDeductScore() {
        return hbDeductScore;
    }

    public void setHbDeductScore(Integer hbDeductScore) {
        this.hbDeductScore = hbDeductScore;
    }

    public Integer getHbPoint() {
        return hbPoint;
    }

    public void setHbPoint(Integer hbPoint) {
        this.hbPoint = hbPoint;
    }
}
