package cn.com.duiba.tuia.commercial.center.api.dto.common.luckydraw;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;

/**
 * CommonLuckyDrawPrizeDto
 *
 * @author huangruodan
 * @date 2019-08-22
 */

@Data
@AllArgsConstructor
@NoArgsConstructor
public class CommonLuckyDrawPrizeDto implements Serializable {
    private static final long serialVersionUID = -373226945323711657L;

    /**
     * 奖励类型
     */
    private Integer prizeType;

    /**
     * 奖励数量，金币或者现金(元)的数量
     */
    private Integer obtainCoin;

    /**
     * 抽奖记录id
     */
    private Long recordId;

    /**
     * 抽奖时间
     */
    private Date gmtCreate;

    /**
     * 用户所在省
     */
    private String province;

    /**
     * 用户所在城市
     */
    private String city;

    public CommonLuckyDrawPrizeDto(Integer prizeType, Integer obtainCoin) {
        this.prizeType = prizeType;
        this.obtainCoin = obtainCoin;
    }
}
