package cn.com.duiba.tuia.commercial.center.api.remoteservice.commercial.dig;


import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.commercial.center.api.dto.commercial.user.req.CommercialUserReq;
import cn.com.duiba.tuia.commercial.center.api.dto.commercial.dig.DigDto;
import cn.com.duiba.tuia.commercial.center.api.dto.commercial.dig.DigStepsConfigDto;
import cn.com.duiba.tuia.commercial.center.api.dto.commercial.dig.req.DigClickReq;
import cn.com.duiba.tuia.commercial.center.api.dto.commercial.dig.req.DigLayerConfigReq;
import cn.com.duiba.tuia.commercial.center.api.dto.commercial.dig.req.DigMissionConfigReq;
import cn.com.duiba.tuia.commercial.center.api.dto.commercial.dig.req.DigNodePrizeConfigReq;
import cn.com.duiba.tuia.commercial.center.api.dto.commercial.mission.req.FinishMissionReq;
import cn.com.duiba.tuia.commercial.center.api.dto.commercial.plant.StockLimitDto;
import cn.com.duiba.tuia.commercial.center.api.dto.commercial.plant.req.ResetForTestReq;

import java.util.ArrayList;
import java.util.List;

@AdvancedFeignClient
public interface RemoteDigService {

    /**
     * 签到
     *
     * @param req 用户参数
     * @return 用户信息  签到信息
     */
    DigDto sign(CommercialUserReq req) throws BizException;


    /**
     * 挖矿点击
     *
     * @param req      用户参数
     * @return 用户信息、任务信息，奖励信息
     */
    DigDto dig(DigClickReq req) throws BizException;



    /**
     * 挖矿点击
     * @param
     * @return 用户信息、任务信息，奖励信息
     */
    boolean updateDigNodePrizeConfig(DigNodePrizeConfigReq req) throws BizException;


    /**
     *
     * @param req 用户信息、任务id
     * @return
     * @throws BizException
     */
    DigDto finishMission(FinishMissionReq req) throws BizException;


    List<ArrayList<Integer>> getTreasureList(CommercialUserReq req) throws BizException;


    /**
     * 更新任务配置
     * @param missionConfigReq appId configDto
     * @return
     */
    boolean updateDigMissionConfig(DigMissionConfigReq missionConfigReq);


    /**
     * 更新层级配置
     */
    boolean updateLayerConfig(DigLayerConfigReq req) throws BizException;

    StockLimitDto getStockLimitDto(Long userId);

    boolean updateStepsConfig(List<DigStepsConfigDto> digStepsConfigDto);

    /**
     * [测试用接口]清除缓存
     *
     * @param req deviceId 设备id appId 媒体id date 签到日期
     */
    Boolean resetForTest(ResetForTestReq req);
}
