package cn.com.duiba.tuia.commercial.center.api.remoteservice.commercial.luckydraw;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.commercial.center.api.dto.commercial.luckydraw.CommercialLuckyDrawInfoDto;
import cn.com.duiba.tuia.commercial.center.api.dto.commercial.luckydraw.CommercialLuckyDrawPrizeDto;
import cn.com.duiba.tuia.commercial.center.api.dto.commercial.luckydraw.req.CommercialLuckyDrawCallbackReq;
import cn.com.duiba.tuia.commercial.center.api.dto.commercial.luckydraw.req.CommercialLuckyDrawInitReq;
import cn.com.duiba.tuia.commercial.center.api.dto.commercial.user.req.CommercialUserReq;

/**
 * RemoteCommercialLuckyDrawService
 *
 * @author huangruodan
 * @date 2019-08-25
 */

@AdvancedFeignClient
public interface RemoteCommercialLuckyDrawService {

    /**
     * 用户抽奖
     * @param userReq 用户信息
     * @return 抽奖结果
     * @throws BizException 业务异常
     */
    CommercialLuckyDrawPrizeDto userLuckyDraw(CommercialUserReq userReq) throws BizException;


    /**
     * 媒体抽奖页面初始化(中奖列表,抽奖配置)
     * @param req 用户信息、活动类型
     * @return 抽奖信息(中奖列表,抽奖配置)
     * @throws BizException 业务异常
     */
    CommercialLuckyDrawInfoDto luckyDrawInit(CommercialLuckyDrawInitReq req) throws BizException;

    /**
     * 抽奖订单回调
     * @param req 推啊订单id,抽奖记录id,用户信息
     * @return 抽奖结果
     * @throws BizException 业务异常
     */
    Boolean luckyDrawOrderCallBack(CommercialLuckyDrawCallbackReq req) throws BizException;
}
