package cn.com.duiba.tuia.commercial.center.api.remoteservice.commercial.tree;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.commercial.center.api.dto.commercial.tree.TreeDto;
import cn.com.duiba.tuia.commercial.center.api.dto.commercial.user.req.CommercialUserReq;

/**
 * RemoteCommercialTreePropService
 *
 * @author huangruodan
 * @date 2019-08-13
 */

@AdvancedFeignClient
public interface RemoteCommercialTreePropService {

    /**
     * 使用水壶
     *
     * @param req         用户信息
     * @return 果树信息
     * @throws BizException 异常
     */
    TreeDto useKettle(CommercialUserReq req) throws BizException;

    /**
     * 使用肥料
     *
     * @param req         用户信息
     * @return 果树信息
     * @throws BizException 异常
     */
    TreeDto useFertilizer(CommercialUserReq req) throws BizException;
}
