package cn.com.duiba.tuia.commercial.center.api.remoteservice.commercial.common;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.commercial.center.api.dto.commercial.user.BizUserDto;
import cn.com.duiba.tuia.commercial.center.api.dto.commercial.user.req.CommercialUserReq;

@AdvancedFeignClient
public interface RemoteBizUserService {

    BizUserDto queryBizUser(CommercialUserReq req);


    /**
     * 更新媒体用户版本号
     * @param appId 媒体id
     * @return 当前版本号
     * @throws BizException 媒体id异常，正在操作中
     */
    Integer updateUserVersionByAppId(Long appId) throws BizException;


    /**
     * 获取媒体用户版本号
     *
     * @param appId
     * @return
     * @throws BizException
     */
    Integer getUserVersionByAppId(Long appId) throws BizException;
}
