package cn.com.duiba.tuia.commercial.center.api.dto.farm;

import lombok.Data;

import java.util.List;

/**
 * 视频返回数据模型
 * FarmVideoDto
 *
 * @author jiangshikui
 * @date 2019-12-23
 */

@Data
public class FarmVideoDto {


    /**
     * 物料类型 1:横幅 2:开屏 3:插屏 4:信
     * 息流 5:激励视频
     */
    private Integer type;

    /**
     * 物料宽度
     */
    private Integer adw;

    /**
     * 物料⾼度
     */
    private Integer adh;

    /**
     * 标题
     */
    private String title;

    /**
     * 描述
     */
    private String desc;

    /**
     * 物料图片地址
     */
    private List<String> image;

    /**
     * 缩略图表
     */
    private List<String> icon;

    /**
     * 深度链接
     */
    private String dplink;

    /**
     * 落地页地址
     */
    private String landingpage;

    /**
     * 互交类型 1：打开⽹页、2：点击下
     * 载、3:⼴点通下载类
     */
    private Integer interaction;

    /**
     * 是否需要在终端做宏替换 0:不需要处
     * 理 1:需要处理，逻辑见下⽂，2: 需要
     * 处理，逻辑见下⽂
     */
    private Integer macro;

    /**
     * 曝光上报地址
     */
    private List<String> shownotice;

    /**
     * 点击上报地址
     */
    private List<String> clicknotice;

    /**
     * deeplink成功调起上报地址
     */
    private List<String> deeplinkclicknotice;

    /**
     * 被下载 app 包名
     */
    private String pkgname;

    /**
     * 被下载 app 名称
     */
    private String appname;

    /**
     * 被下载 app ⼤⼩ 单位：字节
     */
    private String appsize;

    /**
     * ⼴告品牌
     */
    private String brand;

    /**
     * 下载开始上报地址
     */
    private List<String> downloadstart;

    /**
     * 下载结束上报地址
     */
    private List<String> downloadend;

    /**
     * 安装开始上报地址
     */
    private List<String> installstart;

    /**
     * 安装结束上报地址
     */
    private List<String> installend;

    /**
     * 应⽤激活上报地址
     */
    private List<String> active;

    private FarmRewardVideoDto rewardVideo;

    /**
     * ⼴告过期时间 单位：秒（0 表⽰不过期）
     */
    private Long expiration;
}
