package cn.com.duiba.tuia.commercial.center.api.dto.farm.req;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * 随机事件 请求req
 * @author yuantong
 * @version 1.0
 * @since 2019-11-27 12:40
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class FarmEventReq implements Serializable {
    private static final long serialVersionUID = 708508666072558689L;

    /**
     * 1-宝箱 2 - 打地鼠  3-神秘访客
     */
    private Integer type;

    /**
     * 神秘访客时传 1、A金币 2、B金币 3、C金币
     */
    private Integer detailType;

    /**
     * 土地号数
     */
    private Integer landId;

    /**
     * 触发随机事件的方式 有可能是点击触发 也有可能到时间消失 0表示到事件消失 1表示触发了
     */
    private Integer resultType;

    /**
     * 媒体Id
     */
    private Long appId;

    /**
     * 广告位Id
     */
    private Long slotId;

    /**
     * 设备号
     */
    private String deviceId;

    /**
     * 媒体用户Id
     */
    private String mediaUserId;

    /**
     * 用户Id
     */
    private Long consumerId;
}
